/* 
   CC0 2011, Martin Haye

   To the extent possible under law, Martin Haye has waived all copyright 
   and related or neighboring rights to p2e: Pseudo-II Emulator. 
   This work is published from: United States.
*/

//
// High-resolution graphics support
//

/* ======================================================================= */

var qwordToHgrLine = new Array();
var hgrDirty = {};
var pixTblEven = {};
var pixTblOdd = {};
var hgrLineAddrs = new Array();
var hgrInitted = false;

function hgrInit()
{
  var i;
  
  // Only init once.
  if (hgrInitted)
    return;
  hgrInitted = true;
  
  // Precalculate all pixel images
  for (i=0; i<512; i++) {
    pixTblEven[i] = buildPixImg(i, 0);
    pixTblOdd[i] = buildPixImg(i, 1);
  }

  // Calculate the address of each line using Woz's crazy / ingenious scheme
  var addr = 0x2000;
  for (i=0; i<192; i++) {
    hgrLineAddrs[i] = addr;
    addr += 0x400;
    if (addr >= 0x4000) {
      addr = addr - 0x2000 + 0x80;
      if (addr >= 0x2400)
        addr = addr - 0x400 + 0x28;
    }
  }
  
  // We'll need a way to translate address to line number
  qwordToHgrLine = new Array();
  var out = 0;
  for (i=0; i<192; i++) {
    addr = hgrLineAddrs[i];
    for (var j=0; j<40; j+=8)
      qwordToHgrLine[(addr+j)>>3] = i;
  }
  
  // Start with nothing dirty
  hgrDirty = {};
}

// Called when hi-res memory is modified
function hgr_set(addr, val)
{
  var prev = raw_mem[addr];
  if (prev != val) 
  {
    raw_mem[addr] = val;
    if ((addr & 1) == 0) // even addr?
    {
      hgrDirty[addr] = true;
      // Low bit also affects the area to the left
      if ((prev&1) != (val&1)) 
        hgrDirty[addr-2] = true;
    }
    else                 // odd addr
      hgrDirty[addr-1] = true;
  }
}

// Used by buildPixImg below
function setPix(data, off, idx, flip, hb)
{
  idx &= 3;
  if (idx == 0) // black: 0/0/0
    data[off] = data[off+1] = data[off+2] = 0;
  else if (idx == 3) // white: 255/255/255
    data[off] = data[off+1] = data[off+2] = 255;
  else if ((idx^flip) == 1) {
    if (hb) { // blue: 49/49/255
      data[off] = data[off+1] = 49;
      data[off+2] = 255;
    }
    else { // magenta: 206/49/206
      data[off] = data[off+2] = 206;
      data[off+1] = 49;
    }
  }
  else {
    if (hb) { // orange: 255/99/0
      data[off] = 255;
      data[off+1] = 99;
      data[off+2] = 0;
    }
    else { // green: 40/222/40
      data[off] = data[off+2] = 40;
      data[off+1] = 222;
    }
  }
  data[off+3] = 255;
}

// Build the image for a hi-res byte value (odd or even); plus lo bit from next byte.
function buildPixImg(n, evenOdd)
{
  var img = mainCtx.createImageData(7, 1);
  var off = 0;
  var bb = (n & 0x7f) | ((n & 0x100)>>1);
  var hb = n & 0x80;
  var flip = evenOdd ? 3 : 0;
  for (var i=0; i<7; i++) {
    setPix(img.data, off, bb, flip, hb);
    off += 4;
    bb >>= 1;
    flip ^= 3;
  } // for i
  assert(off == 7*4, "bad offset computation");
  
  // Cache for speed
  if (evenOdd)
    pixTblOdd[n] = img;
  else
    pixTblEven[n] = img;
    
  // All done.
  return img;
}

var is_chrome = navigator.userAgent.toLowerCase().indexOf('chrome') > -1;

function refreshHires()
{
  var addr, rx, ry, val;
  
  // For some reason Chrome won't properly update the region unless we make the
  // corners dirty with fillRect.
  //
  if (is_chrome) {
    mainCtx.save();
    mainCtx.fillStyle = "#000000";
    mainCtx.fillRect (0, 0, 1, 1);
    mainCtx.fillRect (279, 191, 280, 192);
    mainCtx.restore();
  }

  // Draw all dirty areas.
  for (addr in hgrDirty)
  {
    addr &= 0x3FFF; // convert to int, and map to page 1
    ry = qwordToHgrLine[addr >> 3];
    if (ry !== undefined) {
      rx = ((addr & 0x7F) % 40) * 7;
      val = raw_mem[addr] + (raw_mem[addr+1] << 8);
      mainCtx.putImageData(pixTblEven[val & 0x1FF], rx, ry);
      val = (val >> 8) + (raw_mem[addr+2] << 8);
      mainCtx.putImageData(pixTblOdd[val & 0x1FF], rx+7, ry);
    }
  }

  // Dirty no longer.  
  hgrDirty = {};
}

// Redraw the high-res screen
function redrawHires()
{
  for (y=0; y<192; y++) {
    addr = hgrLineAddrs[y];
    for (x=0; x<40; x+=2)
      hgrDirty[addr+x] = true;
  }
  refreshHires();
}
